/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.ai.pathfinding;

import com.badlogic.gdx.math.Vector2;
import java.util.Objects;

public class MapPathfindingNode
implements Comparable<MapPathfindingNode> {
    private static final float EPSILON = 1.0E-4f;
    private Vector2 worldPosition;
    private final float costToGetHere;
    private final MapPathfindingNode previousNodeInPath;
    private final float estimateToGoal;

    public MapPathfindingNode(Vector2 worldPosition, float costToGetHere, MapPathfindingNode previousNodeInPath, float estimateToGoal) {
        this.worldPosition = worldPosition;
        this.costToGetHere = costToGetHere;
        this.previousNodeInPath = previousNodeInPath;
        this.estimateToGoal = estimateToGoal;
    }

    @Override
    public int compareTo(MapPathfindingNode other) {
        return Math.round((this.getTotalDistanceFromAndTo() - other.getTotalDistanceFromAndTo()) * 100.0f);
    }

    public float getTotalDistanceFromAndTo() {
        return this.costToGetHere + this.estimateToGoal;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MapPathfindingNode otherNode = (MapPathfindingNode)other;
        return this.worldPosition.epsilonEquals(otherNode.worldPosition, 1.0E-4f);
    }

    public int hashCode() {
        return Objects.hash(this.worldPosition);
    }

    public Vector2 getWorldPosition() {
        return this.worldPosition;
    }

    public float getCostToGetHere() {
        return this.costToGetHere;
    }

    public MapPathfindingNode getPreviousNodeInPath() {
        return this.previousNodeInPath;
    }

    public float getEstimateToGoal() {
        return this.estimateToGoal;
    }

    public void setWorldPosition(Vector2 worldPosition) {
        this.worldPosition = worldPosition;
    }
}

